<?php

namespace Qoxag\Core\Elementor\Controls;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Group_Control_Base;

/**
 * Elementor choose control.
 *
 * A base control for creating choose control. Displays radio buttons styled as
 * groups of buttons with icons for each option.
 *
 * @since 1.0.0
 */
class Qoxag_Post_Query extends Group_Control_Base
{

    protected static $fields;

    public static function get_type()
    {
        return 'postquery';
    }

    protected function init_fields()
    {
        $fields = [];

        $fields['posts_per_page'] = [
            'label' => esc_html__('Posts Count', 'qoxag'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => '6',
            'min' => 1,
            'max' => 50,
            'step' => 1,
            'responsive'    => false
        ];

        $fields['posts_per_page_slider_note'] = [
            'type' => \Elementor\Controls_Manager::RAW_HTML,
            'raw' => esc_html__('Total number of posts to show in the slider. If Slider Controls -> Loop is enabled, slides will repeat again.', 'qoxag'),
            'content_classes' => 'elementor-descriptor',
        ];

        $fields['slides_to_show'] = [
            'label' => esc_html__('Slides to Show', 'qoxag'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => '4',
            'tablet_default' => '2',
            'mobile_default' => '1',
            'min' => 1,
            'max' => 50,
            'step' => 1,
            'description' => esc_html__('Number of slides to be visible in the slider.', 'qoxag'),
            'responsive'    => true
        ];

        // repeater tabs list
        $fields['post_tabs'] = [
            'label' => esc_html__('Post Tabs', 'qoxag'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'default' => [
                [
                    'tab_title' => esc_html__('Add Label', 'qoxag'),
                    'post_cats' => 1,
                ],
            ],
            'title_field' => '{{{ tab_title }}}',
            'fields' => [
                ['name' => 'post_cats',
                    'label' => esc_html__('Select Categories', 'qoxag'),
                    'type' => \Elementor\Controls_Manager::SELECT2,
                    'options' => $this->post_category(),
                    'label_block' => true,
                    'multiple' => true,
                ],
                ['name' => 'tab_title',
                    'label' => esc_html__('Tab title', 'qoxag'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => 'Add Label',
                ],
            ],
        ];

        $fields['post_categories'] = [
            'label' => esc_html__('Select Categories', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => $this->post_category(),
            'multiple' => true,
            'label_block' => true,
        ];

        $fields['post_tags'] = [
            'label' => esc_html__('Select Tags', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => $this->post_tags(),
            'multiple' => true,
            'label_block' => true
        ];

        $fields['post_format'] = [
            'label' => esc_html__('Select Post Format', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => [
                'standard' => esc_html__('Standard', 'qoxag'),
                'video' => esc_html__('Video', 'qoxag'),
            ],
            'default' => [],
            'label_block' => true,
            'multiple' => true,
        ];

        $fields['orderby'] = [
            'label' => esc_html__('Order By', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'date',
            'options' => [
                'date' => esc_html__('Date', 'qoxag'),
                'title' => esc_html__('Title', 'qoxag'),
                'name' => esc_html__('Name', 'qoxag'),
                'rand' => esc_html__('Random', 'qoxag'),
                'ID' => esc_html__('ID', 'qoxag'),
                'name' => esc_html__('Name', 'qoxag'),
                'comment_count' => esc_html__('Popular Posts', 'qoxag'),
            ],
        ];

        $fields['order'] = [
            'label' => esc_html__('Order', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [
                'DESC' => esc_html__('Descending', 'qoxag'),
                'ASC' => esc_html__('Ascending', 'qoxag'),
            ],
        ];

        $fields['enable_offset'] = [
            'label' => esc_html__('Post Skip', 'qoxag'),
            'description' => esc_html__('This field will be used as "Post offset"', 'qoxag'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('Yes', 'qoxag'),
            'label_off' => esc_html__('No', 'qoxag'),
            'default' => 'no',
        ];

        $fields['offset_item_num'] = [
            'label' => esc_html__('Skip Post Count', 'qoxag'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => '1',
            'condition' => ['enable_offset' => 'yes']
        ];

        return $fields;
    }

    protected function get_default_options()
    {
        return [
            'popover' => false,
        ];
    }

    public function post_category() {

        $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1,
        ) );

        $cat_list = [];
        if(!empty($terms)){
            foreach($terms as $post) {
                $cat_list[$post->term_id]  = [$post->name];
            }
        }
        return $cat_list;
    }

    public function post_tags() {
        $terms = get_terms(array(
            'taxonomy' => 'post_tag',
            'hide_empty' => false,
            'posts_per_page' => -1,
        ));

        $tag_list = [];
        if(!empty($terms)){
            foreach ($terms as $post) {
                $tag_list[$post->term_id] = [$post->name];
            }
        }
        return $tag_list;
    }

}
